library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_wm8731_audio is
port (
    signal clk	 		: in  std_logic;     
    signal reset_n 		: in  std_logic;
	signal read 		: in  std_logic;
	signal write		: in  std_logic;	
	signal chipselect	: in  std_logic;
    signal address    	: in  unsigned(1 downto 0);
    signal readdata   	: out unsigned(15 downto 0);
    signal writedata  	: in  unsigned(15 downto 0);
  
    -- Audio interface signals
    signal AUD_ADCLRCK  : out  std_logic;   --    Audio CODEC ADC LR Clock
    signal AUD_ADCDAT   : in   std_logic;   --    Audio CODEC ADC Data
    signal AUD_DACLRCK  : out  std_logic;   --    Audio CODEC DAC LR Clock
    signal AUD_DACDAT   : out  std_logic;   --    Audio CODEC DAC Data
    signal AUD_BCLK     : inout std_logic;  --    Audio CODEC Bit-Stream Clock
	signal AUD_XCK 	 : out std_logic;    -- Chip Clock

	signal I2C_SDAT 	 : inout std_logic; -- I2C Data
    signal I2C_SCLK 	 : out std_logic   -- I2C Clock

	--ps/2
	--PS2_DAT,                    -- Data
    --PS2_CLK : in std_logic;     -- Clock
);
end  de2_wm8731_audio;

architecture rtl of de2_wm8731_audio is     

	--new
	component de2_i2c_av_config is
	port (
		iCLK : in std_logic;
		iRST_N : in std_logic;
		I2C_SCLK : out std_logic;
		I2C_SDAT : inout std_logic
	);
	end component;
	
	signal audio_request: std_logic;
	
	--/other
	signal audio_clock	: std_logic;	--unsigned(2 downto 0)
    signal counter_basic: unsigned(5 downto 0) := "000000";		
    signal counter	 	: unsigned(5 downto 0) := "000000";		
    signal my_data		: unsigned(15 downto 0);
    signal prescaler 	: unsigned(7 downto 0) := X"00";
    signal mid_value	: unsigned(7 downto 0) := X"00";
    signal note			: unsigned(3 downto 0) := X"C";
    signal phase 		: unsigned(15 downto 0):= X"0000";
    signal norm_phase	: signed(5 downto 0)   := "000000";
    signal signed_phase	: signed(5 downto 0)   := "000000";
    signal mod_counter	: unsigned(5 downto 0) := "000000";
    signal mod_depth	: unsigned(1 downto 0) := "01";
    signal extra_counter: unsigned(1 downto 0) := "00";
    signal silent		: std_logic			   := '1';		--CHECK: depende de la repeticion de las teclas
	--new

    signal lrck : std_logic;
    signal bclk : std_logic;
    signal xck  : std_logic;
    
    signal lrck_divider : unsigned(7 downto 0); 
    signal bclk_divider : unsigned(3 downto 0);
    
    signal set_bclk : std_logic;
    signal set_lrck : std_logic;
    signal clr_bclk : std_logic;
    signal lrck_lat : std_logic;
    
    signal shift_out : unsigned(15 downto 0);

	--new lookup tables
	type table is array (0 to 47) of unsigned(15 downto 0);
	constant my_table	: table := (0 => X"0000",1 => X"10b4",2 => X"2120",3 => X"30fb",4 => X"3fff",5 => X"4deb",6 => X"5a81",7 => X"658b",
	8 => X"6ed9",9 => X"7640",10 => X"7ba2",11 => X"7ee6",12 => X"7fff",13 => X"7ee6",14 => X"7ba2",15 => X"7640",16 => X"6ed9",17 => X"658b",
	18 => X"5a81",19 => X"4deb",20 => X"3fff",21 => X"30fb",22 => X"2120",23 => X"10b4",24 => X"0000",25 => X"ef4b",26 => X"dee0",27 => X"cf05",
	28 => X"c001",29 => X"b215",30 => X"a57e",31 => X"9a74",32 => X"9127",33 => X"89bf",34 => X"845d",35 => X"8119",36 => X"8000",37 => X"8119",
	38 => X"845d",39 => X"89bf",40 => X"9127",41 => X"9a74",42 => X"a57e",43 => X"b215",44 => X"c000",45 => X"cf05",46 => X"dee0",47 => X"ef4b");
	type table2 is array (0 to 12) of integer range 0 to 255;  
	constant freq_table : table2 := (0=>18, 1=>20, 2=>21, 3=>22, 4=>23, 5=>24, 6=>26, 7=>28, 8=>29, 9=>30, 10=>32, 11=>34, 12=>36);
	constant mid_table : table2 := (0=>9, 1=>10, 2=>10, 3=>11, 4=>11, 5=>12, 6=>13, 7=>14, 8=>14, 9=>15, 10=>16, 11=>17, 12=>18);

begin
    
  --new
  process (clk)
  begin
	if rising_edge (clk) then
		if prescaler = X"00" then
			prescaler <= TO_UNSIGNED(freq_table(TO_INTEGER(note)),8);
			mid_value <= TO_UNSIGNED(mid_table(TO_INTEGER(note)),8);
			audio_clock <= '0';
		else
			prescaler <= prescaler - 1;
			if prescaler = mid_value then
				audio_clock <= '1';
			end if;			
		end if;
	end if;
  end process;

  process (clk)
  begin
	if rising_edge (clk) then
	  if chipselect = '1' then
		if write = '1' then
		  if address = "00" then
			silent <= '1';
		  elsif address = "01" then
			note <= writedata(3 downto 0);
			silent <= '0';
		  elsif address = "10" then
			mod_depth <= writedata(1 downto 0);
			silent <= '0';		
		  end if;
		end if;
	  end if;
	end if;
  end process;

  process(audio_clock)
  begin
	if rising_edge (audio_clock) then	
		if audio_request = '1' then
			--computing phase
			if extra_counter = "00" then			
				if mod_counter = "101111" or reset_n = '0' then 
					mod_counter <= "000000";
				else
					mod_counter <= mod_counter + 1;
				end if;
				
				phase <= my_table(TO_INTEGER(mod_counter));
				
				norm_phase <= phase(15) & "00" & phase(14) & phase(13) & phase(12);--normalizing the phase
				
				signed_phase <= TO_SIGNED(TO_INTEGER(norm_phase)*TO_INTEGER(mod_depth),6);--scalling the phase
												
				extra_counter <= "10";	-- because Wc = 3Wm
			else
				extra_counter <= extra_counter - 1;
			end if;
		
			--computing period
			if counter_basic >= "101111" or reset_n = '0' then 	--less than 47
				counter_basic <= "000000";
			else
				counter_basic <= counter_basic + 1;							
			end if;
			
			--adding phase(phase) to period(counter_basic)			
			counter <= counter_basic + TO_INTEGER(signed_phase);		--in theory if the real_phase>counter_basic it should reset itself			
						
			--generating sinusoidal
			if silent = '1' then
				my_data <= X"0000";
			else
				my_data <= my_table(TO_INTEGER(counter));
			end if;
		end if;		
	end if;
  end process;

  --new

  process (audio_clock)
  begin
    if rising_edge(audio_clock) then
      if reset_n = '0' then 
        lrck_divider <= (others => '0');
      elsif lrck_divider = X"1F"  then        -- X"BF"
        lrck_divider <= X"00";				  
      else 
        lrck_divider <= lrck_divider + 1;
      end if;
    end if;   
  end process;

  process (audio_clock)
  begin
    if rising_edge(audio_clock) then      						
      if reset_n = '0' then 
        bclk_divider <= (others => '0');
      elsif bclk_divider = X"1" or set_lrck = '1'  then  --X"B"
        bclk_divider <= X"0";
      else 
        bclk_divider <= bclk_divider + 1;
      end if;
    end if;
  end process;

  set_lrck <= '1' when lrck_divider = X"1F" else '0';	--X"BF"

  process (audio_clock)
  begin
    if rising_edge(audio_clock) then
      if reset_n = '0' then
        lrck <= '0';
      elsif set_lrck = '1' then 
        lrck <= not lrck;
      end if;
    end if;
  end process;
    
  -- BCLK divider
  set_bclk <= '1' when bclk_divider(3 downto 0) = X"0" else '0';	--"0101"
  clr_bclk <= '1' when bclk_divider(3 downto 0) = X"1" else '0';	--"1011"
  
  process (audio_clock)
  begin
    if rising_edge(audio_clock) then
      if reset_n = '0' then
        bclk <= '0';
      elsif set_lrck = '1' or clr_bclk = '1' then
        bclk <= '0';
      elsif set_bclk = '1' then 
        bclk <= '1';
      end if;
    end if;
  end process;

  -- Audio data shift output
  process (audio_clock)
  begin
    if rising_edge(audio_clock) then
      if reset_n = '0' then
        shift_out <= (others => '0');
      elsif set_lrck = '1' then
          shift_out <= my_data;
      elsif clr_bclk = '1' then 
        shift_out <= shift_out (14 downto 0) & '0';
      end if;
    end if;   
  end process;

    -- Audio outputs
    
    AUD_ADCLRCK  <= lrck;          
    AUD_DACLRCK  <= lrck;          
    AUD_DACDAT   <= shift_out(15); 
    AUD_BCLK     <= bclk;          
	AUD_XCK <= audio_clock;

    process(audio_clock)
    begin
      if rising_edge(audio_clock) then
        lrck_lat <= lrck;
      end if;
    end process;

    process (audio_clock) 
    begin
      if rising_edge(audio_clock) then 
        if lrck_lat = '1' and lrck = '0' then
          audio_request <= '1';
        else 
          audio_request <= '0';
        end if;
      end if;
    end process;

   
  i2c : de2_i2c_av_config port map (
    iCLK     => clk,
    iRST_n   => '1',
    I2C_SCLK => I2C_SCLK,
    I2C_SDAT => I2C_SDAT
  );

end architecture;


